package gov.va.med.mhv.health.converter;

import gov.va.med.mhv.health.dto.AllergyDTO;
import gov.va.med.mhv.health.model.Allergy;

import java.util.ArrayList;
import java.util.List;

public class AllergiesConverter {
	
	public static AllergyDTO  convertAllergiesDomain( Allergy allergy ){
		AllergyDTO dto = new AllergyDTO();
		dto.setAllergiesId(allergy.getId());
		dto.setAllergy(allergy.getAllergy());
		dto.setComments(allergy.getComments());
		dto.setDiagnosed(allergy.getDiagnosed());
		dto.setEventDate(allergy.getEventDate());
		dto.setReaction(allergy.getReaction());
		dto.setSeverity(allergy.getSeverity());
		dto.setUserprofileId(allergy.getUserprofileId());
		return dto;
	}

	public static Allergy convertAllergiesDTO(AllergyDTO dto){
		Allergy allergy = new Allergy();
		allergy.setAllergy(dto.getAllergy());
		allergy.setComments(dto.getComments());
		allergy.setDiagnosed(dto.getDiagnosed());
		allergy.setEventDate(dto.getEventDate());
		allergy.setId(dto.getAllergiesId());
		allergy.setOplock(0);
		allergy.setReaction(dto.getReaction());
		allergy.setSeverity(dto.getSeverity());
		allergy.setUserprofileId(dto.getUserprofileId());
		return allergy;
	}
	

	public static List<AllergyDTO>  convertAllergiesRecords( List<Allergy> allergies ){
		List<AllergyDTO> dtos = new ArrayList<AllergyDTO>();
		for(Allergy allergy : allergies){
			AllergyDTO dto = convertAllergiesDomain(allergy);
			dtos.add(dto);
		}
		return dtos;
	}
}
